/*
 * Copyright (C) 2022 - 2023, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef LC_HASH_DRBG_SHA512_H
#define LC_HASH_DRBG_SHA512_H

#include "lc_sha512.h"

#ifdef __cplusplus
extern "C" {
#endif

#if defined(LC_DRBG_HASH_STATELEN) || defined(LC_DRBG_HASH_BLOCKLEN) ||        \
	defined(LC_DRBG_HASH_CORE)
#error "You have included more than one DRBG header file!"
#endif

#define LC_DRBG_HASH_STATELEN 111
#define LC_DRBG_HASH_BLOCKLEN 64

#define LC_DRBG_HASH_CORE lc_sha512

#include "lc_hash_drbg.h"

#ifdef __cplusplus
}
#endif

#endif /* LC_HASH_DRBG_SHA512_H */
