#
# spec file for package esdm
#
# Copyright (c) 2024 - 2025 Stephan Mueller <smueller@chronox.de
#

Name:           esdm
Version:        1.2.1
Release:        1.1
Summary:        Entropy Source and DRNG Manager
License:        GPL-2.0 OR BSD-2-Clause
URL:            https://www.chronox.de/esdm
Source0:        https://www.chronox.de/%{name}/releases/%{version}/%{name}-%{version}.tar.xz
BuildRequires:  meson
BuildRequires:  gcc
BuildRequires:  fuse3
BuildRequires:  fuse3-devel
BuildRequires:  leancrypto-devel
BuildRequires:  libjitterentropy3
BuildRequires:  libprotobuf-c-devel
BuildRequires:  pkgconfig
BuildRequires:  libopenssl-devel
BuildRequires:  gcc-c++
BuildRequires:  meson
BuildRequires:  ninja
BuildRequires:  systemd-rpm-macros

%description
The Entropy Source and DRNG Manager (ESDM) manages a set of deterministic
random number generators (DRNG) and ensures their proper seeding and reseeding.
To seed the DRNGs, a set of entropy sources are managed by the ESDM. The
cryptographic strength of the entire ESDM is always 256 bits. All entropy
processing is designed to maintain this strength.

%package %{name}
Summary:        Entropy Source and DRNG Manager
Requires:       libjitterentropy
Requires:       libleancrypto1
Requires:       libprotobuf

%description %{name}
The Entropy Source and DRNG Manager (ESDM) manages a set of deterministic
random number generators (DRNG) and ensures their proper seeding and reseeding.
To seed the DRNGs, a set of entropy sources are managed by the ESDM. The
cryptographic strength of the entire ESDM is always 256 bits. All entropy
processing is designed to maintain this strength.

This subpackage holds the ESDM server, and the RPC client library allowing
users to interact with the ESDM via its APIs.

%package devel
Summary:        Entropy Source and DRNG Manager
Requires:       glibc-devel
Requires:       libjitterentropy3
Requires:       leancrypto-devel
Requires:       libprotobuf-c-devel

%description devel
The Entropy Source and DRNG Manager (ESDM) manages a set of deterministic
random number generators (DRNG) and ensures their proper seeding and reseeding.
To seed the DRNGs, a set of entropy sources are managed by the ESDM. The
cryptographic strength of the entire ESDM is always 256 bits. All entropy
processing is designed to maintain this strength.

This subpackage holds the development headers for the libraries.

%package devel-static
Summary:        Static library for ESDM
Requires:       %{name}-devel = %{version}
Provides:       %{name}-devel:%{_libdir}/lib%{name}_rpc_client.a

%description devel-static
The Entropy Source and DRNG Manager (ESDM) manages a set of deterministic
random number generators (DRNG) and ensures their proper seeding and reseeding.
To seed the DRNGs, a set of entropy sources are managed by the ESDM. The
cryptographic strength of the entire ESDM is always 256 bits. All entropy
processing is designed to maintain this strength.

This subpackage contains the static version of the library
used for development.

%package -n %{name}-cuse
Summary:        Entropy Source and DRNG Manager CUSE device files
Requires:       fuse3
Requires:       %{name} = %{version}

%description -n %{name}-cuse
The Entropy Source and DRNG Manager (ESDM) manages a set of deterministic
random number generators (DRNG) and ensures their proper seeding and reseeding.
To seed the DRNGs, a set of entropy sources are managed by the ESDM. The
cryptographic strength of the entire ESDM is always 256 bits. All entropy
processing is designed to maintain this strength.

This subpackage holds the ESDM CUSE device files of /dev/random and
/dev/urandom as well as the files in /proc/sys/kernel/random/. Therefore, this
package turns the ESDM in an API and ABI drop-in replacement of the Linux
/dev/random device for user space.

%package -n %{name}-openssl
Summary:        Entropy Source and DRNG Manager OpenSSL RAND Provider
Requires:       %{name} = %{version}

%description -n %{name}-openssl
The Entropy Source and DRNG Manager (ESDM) manages a set of deterministic
random number generators (DRNG) and ensures their proper seeding and reseeding.
To seed the DRNGs, a set of entropy sources are managed by the ESDM. The
cryptographic strength of the entire ESDM is always 256 bits. All entropy
processing is designed to maintain this strength.

This subpackage holds the OpenSSL 3 RAND provider

%prep
%setup -q

%build
# No SELinux support
%meson -Dais2031=true -Dsp80090c=true -Dcrypto_backend=leancrypto -Dselinux=disabled -Dopenssl-rand-provider=enabled
%meson_build

%check
%meson_test

%install
%meson_install

%pre -n %{name}
%systemd_add_pre %{name}-server.service
%systemd_add_pre %{name}-server-suspend.service
%systemd_add_pre %{name}-server-resume.service

%pre -n %{name}-cuse
%systemd_add_pre %{name}-linux-compat.target

%post -n %{name}
/sbin/ldconfig
%systemd_add_post %{name}-server.service
%systemd_add_post %{name}-server-suspend.service
%systemd_add_post %{name}-server-resume.service

  if [ $1 -eq 1 ]; then
    /usr/bin/systemctl daemon-reload
    /usr/bin/systemctl start %{name}-server
    /usr/bin/systemctl enable %{name}-server
    /usr/bin/systemctl enable %{name}-server-suspend
    /usr/bin/systemctl enable %{name}-server-resume
  fi
  if [ $1 -eq 2 ]; then
    /usr/bin/systemctl daemon-reload
    /usr/bin/systemctl start %{name}-server
    /usr/bin/systemctl enable %{name}-server
    /usr/bin/systemctl enable %{name}-server-suspend
    /usr/bin/systemctl enable %{name}-server-resume
  fi

%post -n %{name}-cuse
%systemd_add_post %{name}-linux-compat.target

  if [ $1 -eq 1 ]; then
    /usr/bin/systemctl daemon-reload
    /usr/bin/systemctl start %{name}-linux-compat.target
    /usr/bin/systemctl enable %{name}-linux-compat.target
  fi
  if [ $1 -eq 2 ]; then
    /usr/bin/systemctl daemon-reload
    /usr/bin/systemctl start %{name}-linux-compat.target
    /usr/bin/systemctl enable %{name}-linux-compat.target
  fi

%post -n %{name}-openssl -p /sbin/ldconfig

%preun -n %{name}
%systemd_del_preun %{name}-server.service
%systemd_del_preun %{name}-server-suspend.service
%systemd_del_preun %{name}-server-resume.service

%preun -n %{name}-cuse
%systemd_del_preun %{name}-linux-compat.target

%postun -n %{name}
/sbin/ldconfig
%systemd_del_postun %{name}-server.service
%systemd_del_postun %{name}-server-suspend.service
%systemd_del_postun %{name}-server-resume.service

%postun -n %{name}-cuse
%systemd_del_postun %{name}-linux-compat.target

%postun -n %{name}-openssl -p /sbin/ldconfig

%files -n %{name}
%license LICENSE LICENSE.bsd LICENSE.gplv2
%doc README.md README.usage.md
%{_libdir}/lib%{name}_aux*.so*
%{_libdir}/lib%{name}-getrandom*.so*
%{_libdir}/lib%{name}_rpc_client*.so*
%{_libdir}/lib%{name}.so*
%{_libdir}/pkgconfig/%{name}_*.pc
%{_libdir}/pkgconfig/%{name}-*.pc
%{_bindir}/esdm-server*
%{_unitdir}/esdm-server*

%files -n %{name}-cuse
%{_bindir}/esdm-cuse*
%{_bindir}/esdm-proc
%{_unitdir}/esdm-cuse*
%{_unitdir}/esdm-proc.service
%{_unitdir}/esdm-linux-compat.target

%files -n %{name}-openssl
%{_libdir}/lib%{name}-rng-provider*.so*
%{_libdir}/lib%{name}-seed-src-provider*.so*

%files devel
%doc CHANGES.md
%{_includedir}/%{name}

%files devel-static
%{_libdir}/lib%{name}_aux_client.a
%{_libdir}/lib%{name}-getrandom.a
%{_libdir}/lib%{name}_rpc_client.a
